/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.util.leap.Collection;
import jade.util.leap.EmptyIterator;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import jade.util.leap.Set;
import java.util.Enumeration;
import java.util.Hashtable;

public class HashMap
implements Map,
Serializable {
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Collection values = null;
    private Hashtable hiddenMap;
    private static final long serialVersionUID = 3487495895819395L;
    private static final Long nullValue = new Long(3487495895819395L);
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public HashMap() {
        this.hiddenMap = new Hashtable();
    }

    public HashMap(int s) {
        this.hiddenMap = new Hashtable(s);
    }

    public boolean isEmpty() {
        return this.hiddenMap.isEmpty();
    }

    public Object remove(Object o) {
        ++this.modCount;
        o = o != null ? o : nullValue;
        Object ret = this.hiddenMap.remove(o);
        return nullValue.equals(ret) ? null : ret;
    }

    public Object put(Object key, Object value) {
        ++this.modCount;
        key = key != null ? key : nullValue;
        value = value != null ? value : nullValue;
        Object previous = this.hiddenMap.put(key, value);
        return nullValue.equals(previous) ? null : previous;
    }

    public boolean containsKey(Object key) {
        key = key != null ? key : nullValue;
        return this.hiddenMap.containsKey(key);
    }

    public Object get(Object key) {
        key = key != null ? key : nullValue;
        Object ret = this.hiddenMap.get(key);
        return nullValue.equals(ret) ? null : ret;
    }

    public int size() {
        return this.hiddenMap.size();
    }

    public void clear() {
        ++this.modCount;
        this.hiddenMap.clear();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return HashMap.this.getMapIterator(0);
                }

                public boolean isEmpty() {
                    return HashMap.this.hiddenMap.isEmpty();
                }

                public boolean remove(Object o) {
                    int oldSize = this.size();
                    HashMap.this.hiddenMap.remove(o);
                    return this.size() != oldSize;
                }

                public int size() {
                    return HashMap.this.hiddenMap.size();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Collection(){

                public boolean add(Object o) {
                    throw new RuntimeException();
                }

                public boolean isEmpty() {
                    return HashMap.this.hiddenMap.isEmpty();
                }

                public boolean remove(Object o) {
                    throw new RuntimeException();
                }

                public Iterator iterator() {
                    return HashMap.this.getMapIterator(1);
                }

                public Object[] toArray() {
                    Object[] result = new Object[this.size()];
                    Iterator e = this.iterator();
                    int i = 0;
                    while (e.hasNext()) {
                        result[i] = e.next();
                        ++i;
                    }
                    return result;
                }

                public int size() {
                    return HashMap.this.hiddenMap.size();
                }
            };
        }
        return this.values;
    }

    private Iterator getMapIterator(int type) {
        if (this.size() == 0) {
            return EmptyIterator.getInstance();
        }
        return new MapIterator(type);
    }

    private class MapIterator
    implements Iterator {
        Enumeration elements;
        private int expectedModCount;

        MapIterator(int type) {
            this.expectedModCount = HashMap.this.modCount;
            if (type == 0) {
                this.elements = HashMap.this.hiddenMap.keys();
            } else if (type == 1) {
                this.elements = HashMap.this.hiddenMap.elements();
            }
        }

        public boolean hasNext() {
            return this.elements.hasMoreElements();
        }

        public Object next() {
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new RuntimeException();
            }
            Object ret = this.elements.nextElement();
            return nullValue.equals(ret) ? null : ret;
        }

        public void remove() {
            throw new RuntimeException();
        }
    }

    private abstract class AbstractSet
    implements Set {
        private AbstractSet() {
        }

        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        public boolean add(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public Iterator iterator() {
            throw new RuntimeException();
        }

        public int size() {
            throw new RuntimeException();
        }
    }
}

